function [varargout] = OptimisationPanel(varargin)
global data_OP matrix_b matrix_h elem_b elem_h count

if nargin==0  %LAUNCH GUI
    global OP_flag
    data_OP = [];
    
    if isempty(OP_flag)     %flag = 1 if OP launch the GUI
        close all hidden
    end
    
    %LAYOUT      
    data_OP.Ver = '2022-05-15';
    data_OP.GUITag = 'OP';
    
    disp('  ')
    disp('Optimisation Panel')
    disp(['    Politecnico di Torino - (C)ver. ' data_OP.Ver])
    disp('    Main developers: Elvio Bonisoli, Simone Venturini, Mariam Sadek')
    disp('  ')
    
    data_OP.debug = 0;
    data_OP.cd_orig = cd;    
    
    data_OP.popupmenu_OF = [];
    data_OP.Load_OF = [];
    data_OP.CMlabel = [];
    data_OP.CMedit = [];
    data_OP.Hlabel = [];
    data_OP.Hedit = [];
    data_OP.Alabel = [];
    data_OP.Aedit = [];
    data_OP.blabel = [];
    data_OP.bedit = [];
    data_OP.Vlabel = [];
    data_OP.V = [];
    data_OP.bnlabel = [];
    data_OP.bnedit = [];
    data_OP.Load_CR = [];
    data_OP.CR1edit = [];
    data_OP.CR2edit = [];
    data_OP.Variables = [];
    data_OP.variabletable = [];
    data_OP.VariableLabel = [];
    data_OP.VariableEdit = [];
    data_OP.VariableDescriptionLabel = [];
    data_OP.VariableDescriptionEdit = [];
    data_OP.VariableUnitLabel = [];
    data_OP.VariableUnitEdit = [];
    data_OP.edit = [];
    data_OP.delete = [];
    data_OP.lb = [];
    data_OP.lbedit = [];
    data_OP.ub = [];
    data_OP.ubedit = [];
    data_OP.Display_OF = [];
    data_OP.c = [];
    data_OP.ceq = [];
    data_OP.fval = [];
    data_OP.x = [];
    data_OP.ld = 0;
    data_OP.reg = 0;
    data_OP.app = 0;
    data_OP.Options = [];
    
    data_OP.h1 = [];
    data_OP.h2 = [];
    data_OP.h3 = [];
    data_OP.h4 = [];
        
    % Default layout values
    elem_b = [0.03 0.04 0.095 0.20 0.41 0.515 0.73];
    elem_h = [0.08 0.06 0.045];
    matrix_b = [0.035 0.14 0.245 0.35 0.455 0.56 0.665 0.77 0.875];
    matrix_h = 0.03+elem_h(1,1)*[11 10 9 8 7 6 5 4 3 2 1 0];
    count = 0;
    
    data_OP.scrsz = get(0,'ScreenSize');
    figsz = [1240 350 640 450];
    figsz = [data_OP.scrsz(1,3)/1920 data_OP.scrsz(1,4)/1080 data_OP.scrsz(1,3)/1920 data_OP.scrsz(1,4)/1080].*figsz;
    
    % Create the figure fig = figure(...)
    data_OP.GUI = figure(...
        'MenuBar','none',...
        'Color',[1 1 1],...
        'IntegerHandle','off', ...
        'Name','Optimisation Panel',...
        'NumberTitle','off',...
        'PaperPosition',[0.6345175 6.345175 20.30456 15.22842],...
        'PaperSize',[20.98404194812 29.67743169791],...
        'Position',figsz,...
        'Interruptible','on', ...
        'HandleVisibility','callback',...
        'Tag','Optimisation Panel');
    
    defUnits = get(0,'defaultuicontrolUnits');
    set(0,'defaultuicontrolUnits','normalized');
    set(0,'defaultuicontrolBackgroundColor',[1 1 1]);
    
    % Frame
    uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[0.02 0.02 0.96 0.96],...
        'Style','frame');
    
    % Internal grid division
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'Position',[0.02 0.02+1*elem_h(1,1) 0.96 10*elem_h(1,1)], ...
        'Style','frame');
    
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'Position',[0.02 0.02+1*elem_h(1,1) 0.96 5*elem_h(1,1)], ...
        'Style','frame');
    
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'Position',[0.02 0.02+1*elem_h(1,1) 0.96 2*elem_h(1,1)], ...
        'Style','frame');
    
    % Title
    uicontrol(...
        'Parent',data_OP.GUI,...
        'FontSize',12,...
        'FontWeight','demi',...
        'Position',[matrix_b(1,1)+0.04 0.905 0.86 elem_h(1,2)],...
        'String','Optimisation Panel',...
        'Style','text');
    
    %OP version
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'FontWeight','demi', ...
        'Position',[0.75 0.91 0.22 elem_h(1,3)], ...
        'String',['ver. ' data_OP.Ver], ...
        'Style','text');
    
    % Decision Variables
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'FontSize',9, ...
        'FontWeight','demi', ...
        'Position',[matrix_b(1,1) matrix_h(1,2) elem_b(1,5) elem_h(1,3)], ...
        'horizontalAlignment','left',...
        'String','Decision Variables', ...
        'Style','text');
    
    data_OP.variabletable = uitable('Parent', data_OP.GUI, ...
        'Units', 'normalized', ...
        'BackgroundColor', [1 1 1], ...
        'Position', [matrix_b(1,6)-elem_b(1,3) matrix_h(1,6) 0.5 0.37], ...
        'Data', data_OP.Variables, 'ColumnName', {'  Variable  ' '    Description    ' '  Unit  ' '  Lower Bound  ' '  Initial Value  ' '  Upper Bound  '}, ...
        'CellSelectionCallback', @Sub_SelectVariable);
    
    data_OP.delete = uicontrol( ...
        'Parent',data_OP.GUI, ...
        'Position',[matrix_b(1,4) matrix_h(1,4) elem_b(1,3) elem_h(1,3)], ...
        'String','Delete', ...
        'Style','pushbutton', ...
        'Callback', {@Sub_DeleteVariable});
    
    data_OP.edit = uicontrol( ...
        'Parent',data_OP.GUI, ...
        'Position',[matrix_b(1,4) matrix_h(1,3) elem_b(1,3) elem_h(1,3)], ...
        'String','Edit', ...
        'Style','pushbutton', ...
        'Callback', {@Sub_EditVariable});
    
    data_OP.Load_DV = uicontrol( ...
        'Parent',data_OP.GUI, ...
        'Position',[matrix_b(1,3) matrix_h(1,2) elem_b(1,3) elem_h(1,3)], ...
        'String','Load', ...
        'Style','pushbutton', ...
        'Callback', {@Sub_RunVariableFile});
    
    data_OP.VariableLabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,3) elem_b(1,3) elem_h(1,2)],...
        'String','Variable',...
        'Style','text');
    data_OP.VariableEdit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,4) elem_b(1,3) elem_h(1,2)],...
        'Style','edit', ...
        'Callback', {@Sub_EnableAdd});
    
    data_OP.x0 = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,2) matrix_h(1,5) elem_b(1,3) elem_h(1,2)],...
        'String','Initial Value',...
        'Style','text');
    data_OP.x0edit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,2) matrix_h(1,6) elem_b(1,3) elem_h(1,2)],...
        'Style','edit');
    
    data_OP.VariableDescriptionLabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,2) matrix_h(1,3) elem_b(1,4)-elem_b(1,3) elem_h(1,2)],...
        'String','Description',...
        'Style','text');
    data_OP.VariableDescriptionEdit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,2) matrix_h(1,4) elem_b(1,3) elem_h(1,2)],...
        'Style','edit');
    
    data_OP.VariableUnitLabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,3) matrix_h(1,3) elem_b(1,3) elem_h(1,2)],...
        'String','Unit',...
        'Style','text');
    data_OP.VariableUnitEdit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,3) matrix_h(1,4) elem_b(1,3) elem_h(1,2)],...
        'Style','edit');
    
    data_OP.lb = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,5) matrix_b(1,2)-elem_b(1,2) elem_h(1,2)],...
        'String', 'Lower Bound',...
        'Style','text');
    data_OP.ub = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,3) matrix_h(1,5) matrix_b(1,2)-elem_b(1,2) elem_h(1,2)],...
        'String', 'Upper Bound',...
        'Style','text');
    
    data_OP.lbedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,6) matrix_b(1,2)-elem_b(1,2) elem_h(1,2)],...
        'Style','edit');
    data_OP.ubedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,3) matrix_h(1,6) matrix_b(1,2)-elem_b(1,2) elem_h(1,2)],...
        'Style','edit');
    
    data_OP.pushbutton_add = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,4)+elem_b(1,1) matrix_h(1,6) elem_b(1,3)-elem_b(1,2) elem_h(1,2)],...
        'Callback', {@Sub_AddVariable}, ...
        'String','Add',...
        'Style','pushbutton', ...
        'Enable', 'off');

    
    % Objective Function
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'FontSize',9, ...
        'FontWeight','demi', ...
        'Position',[matrix_b(1,1) matrix_h(1,7) elem_b(1,5) elem_h(1,3)], ...
        'horizontalAlignment','left',...
        'String','Objective Function', ...
        'Style','text');
    
    data_OP.checkbox_min = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,8) elem_b(1,4) elem_h(1,3)],...
        'Callback', {@Sub_ChangeObjFuncSign}, ...
        'String',{'Minimise'},...
        'Style','checkbox');
    
    data_OP.checkbox_max = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,9) elem_b(1,4) elem_h(1,3)],...
        'Callback', {@Sub_ChangeObjFuncSign}, ...
        'String',{'Maximise'},...
        'Style','checkbox');
    
    set(0,'defaultUIControlTag','OF');
    
    data_OP.popupmenu_OF = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,3) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'Callback', {@Sub_ChangeObjFunc}, ...
        'String',{'Linear' 'Quadratic' 'nth Polynomial' 'Other'},...
        'Style','popupmenu');
    
    data_OP.Load_OF = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,4) matrix_h(1,8) elem_b(1,3) elem_h(1,3)],...
        'Callback', {@Sub_RunObjFuncFile}, ...
        'Enable', 'off', ...
        'String',{'Load File'});
    
    data_OP.Display_OF = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,8) elem_b(1,5) elem_h(1,3)],...
        'Visible', 'off', ...
        'Style','edit');
    
    data_OP.CMlabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'String',{'Coefficients Vector'},...
        'Style','text', ... 
        'Tag', 'Linear', ...
        'Visible', 'off');
    
    data_OP.CMedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,7) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'Style','edit', ...
        'Tag', 'Linear', ...
        'Visible', 'off');
    data_OP.hLinear = findobj(data_OP.GUI, 'Tag', 'Linear');
    
    data_OP.Hlabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'String',{'H Matrix'},...
        'Style','text', ...
        'Tag', 'Quadratic', ...
        'Visible', 'off');
    
    data_OP.Hedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,7) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'Style','edit', ...
        'Tag', 'Quadratic', ...
        'Visible', 'off');
    
    data_OP.Alabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,8) elem_b(1,4) elem_h(1,3)],...
        'String', {'A Matrix'},...
        'Style','text', ...
        'Tag', 'Quadratic', ...
        'Visible', 'off');
    
    data_OP.Aedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,7) matrix_h(1,8) elem_b(1,4) elem_h(1,3)],...
        'Style','edit', ...
        'Tag', 'Quadratic', ...
        'Visible', 'off');
    
    data_OP.blabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,9) elem_b(1,4) elem_h(1,3)],...
        'String', {'Constant Coefficient'},...
        'Style','text', ...
        'Tag', 'Quadratic', ...
        'Visible', 'off');
    
    data_OP.bedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,7) matrix_h(1,9) elem_b(1,4) elem_h(1,3)],...
        'Style','edit', ...
        'Tag', 'Quadratic', ...
        'Visible', 'off');
    
    data_OP.hQuadratic = findobj(data_OP.GUI, 'Tag', 'Quadratic');
    
    data_OP.Vlabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'String', 'Coeff/degree Matrix',...
        'Style','text', ...
        'Tag', 'Polynomial', ...
        'Visible', 'off');
    
    data_OP.V = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,7) matrix_h(1,7) elem_b(1,4) elem_h(1,3)],...
        'Style','edit', ...
        'Tag', 'Polynomial', ...
        'Visible', 'off');
    
    data_OP.bnlabel = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,5) matrix_h(1,8) elem_b(1,4) elem_h(1,3)],...
        'String', 'Constant Term',...
        'Style','text', ...
        'Tag', 'Polynomial', ...
        'Visible', 'off');
    
    data_OP.bnedit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,7) matrix_h(1,8) elem_b(1,4) elem_h(1,3)],...
        'Style','edit', ...
        'Tag', 'Polynomial', ...
        'Visible', 'off');
    
    data_OP.hPolynomial = findobj(data_OP.GUI, 'Tag', 'Polynomial');
    
    % Constraints
    uicontrol( ...
        'Parent',data_OP.GUI, ...
        'FontSize',9, ...
        'FontWeight','demi', ...
        'Position',[matrix_b(1,1) matrix_h(1,10) elem_b(1,5) elem_h(1,3)], ...
        'horizontalAlignment','left',...
        'String','Constraint Relations', ...
        'Style','text');
    
    uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[elem_b(1,1) matrix_h(1,11) elem_b(1,3) elem_h(1,3)],...
        'String','NonLinear',...
        'Style','text');
    
    data_OP.Load_CR = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,2) matrix_h(1,11) elem_b(1,3) elem_h(1,3)],...
        'Callback', {@Sub_RunConstraintFile}, ...
        'String','Load File');
    
    data_OP.Display_C = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,4)-elem_b(1,3) matrix_h(1,10) 3*elem_b(1,3) elem_h(1,3)],...
        'Style', 'edit', ...
        'Enable','off');
    
    data_OP.Display_Ceq = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,4)-elem_b(1,3) matrix_h(1,11) 3*elem_b(1,3) elem_h(1,3)],...
        'Style', 'edit', ...
        'Enable','off');
    
    uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,6) matrix_h(1,10) elem_b(1,4) elem_h(1,3)],...
        'String','Linear Equality',...
        'Style','text');
    
    uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,6) matrix_h(1,11) elem_b(1,4) elem_h(1,3)],...
        'String', 'Linear Inequality',...
        'Style','text');
    
    data_OP.CR1edit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,8) matrix_h(1,10) elem_b(1,4) elem_h(1,3)],...
        'Style','edit');
    
    data_OP.CR2edit = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,8) matrix_h(1,11) elem_b(1,4) elem_h(1,3)],...
        'Style','edit');
    
    % Find Min/Max
    data_OP.pushbutton_min = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,8) matrix_h(1,12) elem_b(1,4) elem_h(1,2)],...
        'Callback', {@Sub_RunOptimisation}, ...
        'String','Find Optimum',...
        'Style','pushbutton',...
        'Enable','on');
    
    % Load Problem
    data_OP.pushbutton_load = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,1) matrix_h(1,12) elem_b(1,4) elem_h(1,2)],...
        'Callback', {@Sub_LoadProblem}, ...
        'String','Load Problem',...
        'Style','pushbutton',...
        'Enable','on');
    
    % Plot/Save Options
    data_OP.checkbox_plot = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,4) matrix_h(1,12) elem_b(1,4) elem_h(1,3)],...
        'String',{'Enable Plot'},...
        'Style','checkbox');
    
    data_OP.checkbox_save = uicontrol(...
        'Parent',data_OP.GUI,...
        'Position',[matrix_b(1,6)-elem_b(1,2) matrix_h(1,12) elem_b(1,4) elem_h(1,3)],...
        'String',{'Enable Save'},...
        'Style','checkbox');
    
    set(0,'defaultuicontrolUnits',defUnits);
end

%% AUXILIARY FUNCTIONS
function Sub_EnableAdd(~, ~)
global data_OP
x = get(data_OP.VariableEdit, 'String');
if isempty(str2num(x))==0 || isempty(x)==1
    set(data_OP.pushbutton_add, 'Enable', 'off');
else
    set(data_OP.pushbutton_add, 'Enable', 'on');
end

function Sub_AddVariable(~, ~)
global data_OP
x = get(data_OP.VariableEdit, 'String');
y = get(data_OP.VariableDescriptionEdit, 'String');
z = get(data_OP.VariableUnitEdit, 'String');
w = get(data_OP.lbedit, 'String');
h = get(data_OP.x0edit, 'String');
q = get(data_OP.ubedit, 'String');
n = size(data_OP.Variables);
for p = 1:n(1)
    if strcmp(x, data_OP.Variables(p,1))==1 || isempty(x)
        disp('Each variable should be unique. Please input a valid name.');
        return;
    end
end
if  str2num(w)>=str2num(q)
    disp('The value of the upper bound should be higher than that of the lower bound.');
    return;
elseif isempty(str2num(w))
    disp('If the variable is not left-bounded, set the lower bound to -inf. If not, please input a valid value');
    return;
elseif isempty(str2num(q))
    disp('If the variable is not right-bounded, set the upper bound to inf. If not, please input a valid value');
    return;
end
if str2num(h)>str2num(q) || str2num(h)<str2num(w) || isempty(str2num(h))
    disp('The initial value should lay between the lower and upper bounds.');
    return;
end   
if isempty(z)
    disp('Please input a valid unit. If the variable is dimensionless, set the unit to -');
    return;
end
data_OP.Variables = [data_OP.Variables; {x y z w h q}];
set(data_OP.VariableEdit, 'String', '');
set(data_OP.VariableDescriptionEdit, 'String', '');
set(data_OP.VariableUnitEdit, 'String', '');
set(data_OP.lbedit, 'String', '');
set(data_OP.x0edit, 'String', '');
set(data_OP.ubedit, 'String', '');
set(data_OP.variabletable, 'Data', data_OP.Variables);
set(data_OP.pushbutton_add, 'Enable', 'off');

function Sub_SelectVariable(src,event)
set(src,'UserData', event.Indices);

function Sub_EditVariable(~,~)
global data_OP
index = get(data_OP.variabletable,'UserData');
if isempty(index)
    disp('Please select a cell to modify.');
    return;
end
x = get(data_OP.VariableEdit, 'String');
y = get(data_OP.VariableDescriptionEdit, 'String');
z = get(data_OP.VariableUnitEdit, 'String');
w = get(data_OP.lbedit, 'String');
h = get(data_OP.x0edit, 'String');
q = get(data_OP.ubedit, 'String');
n = size(data_OP.Variables);

switch index(2)
    case 1
       for p = 1:n(1)
             if strcmp(x, data_OP.Variables(p,1))==1 || isempty(x)
                 disp('Each variable should be unique. Please input a valid name.');
                 return;
             end
       end
       data_OP.Variables(index(1),index(2)) = {x};
    case 2
       data_OP.Variables(index(1),index(2)) = {y};
    case 3
       if isempty(z)
           disp('Please input a valid unit. If the variable is dimensionless, set the unit to -');
           return;
       end
       data_OP.Variables(index(1),index(2)) = {z};
    case 4
       if str2num(w)>=str2double(data_OP.Variables(index(1),6)) || str2num(w)>str2double(data_OP.Variables(index(1),5))
           disp('The value of the lower bound should be smaller than that of the initial value and the upper bound.');
           return;
       elseif isempty(str2num(w))
           disp('If the variable is not left-bounded, set the lower bound to -inf. If not, please input a valid value');
           return;
       end
       data_OP.Variables(index(1),index(2)) = {w};
    case 5
       if str2num(h)>str2double(data_OP.Variables(index(1),6)) || str2num(h)<str2double(data_OP.Variables(index(1),4)) || isempty(str2num(h))
           disp('The initial value should lay between the lower and upper bounds.');
           return;
       end
       data_OP.Variables(index(1),index(2)) = {h};
    case 6
       if str2double(data_OP.Variables(index(1),4))>=str2num(q) || str2num(q)<str2double(data_OP.Variables(index(1),5))
           disp('The value of the upper bound should be higher than that of the lower bound and the initial value.');
           return;
       elseif isempty(str2num(q))
           disp('If the variable is not right-bounded, set the upper bound to inf. If not, please input a valid value');
           return;
       end
       data_OP.Variables(index(1),index(2)) = {q};
end
set(data_OP.VariableEdit, 'String', '');
set(data_OP.VariableDescriptionEdit, 'String', '');
set(data_OP.VariableUnitEdit, 'String', '');
set(data_OP.lbedit, 'String', '');
set(data_OP.x0edit, 'String', '');
set(data_OP.ubedit, 'String', '');
set(data_OP.variabletable, 'Data', data_OP.Variables);
set(data_OP.pushbutton_add, 'Enable', 'off');

function Sub_DeleteVariable(~,~)
global data_OP
index = get(data_OP.variabletable,'UserData');
if isempty(index)
    disp('Please select a row to delete.');
    return;
end
data_OP.Variables(index(1),:)=[];
set(data_OP.variabletable,'Data',data_OP.Variables);

function Sub_ChangeObjFunc(~,~)
global data_OP
switch data_OP.popupmenu_OF.Value
    case 1
        set(data_OP.hLinear, 'Visible', 'on');
        set(data_OP.hQuadratic, 'Visible', 'off');
        set(data_OP.hPolynomial, 'Visible', 'off');
        set(data_OP.Load_OF, 'Enable', 'off');
        set(data_OP.Display_OF, 'Visible', 'off');
    case 2
        set(data_OP.hLinear, 'Visible', 'off');
        set(data_OP.hQuadratic, 'Visible', 'on');
        set(data_OP.hPolynomial, 'Visible', 'off');
        set(data_OP.Load_OF, 'Enable', 'off');
        set(data_OP.Display_OF, 'Visible', 'off');
    case 3
        set(data_OP.hLinear, 'Visible', 'off');
        set(data_OP.hQuadratic, 'Visible', 'off');
        set(data_OP.hPolynomial, 'Visible', 'on');
        set(data_OP.Load_OF, 'Enable', 'off');
        set(data_OP.Display_OF, 'Visible', 'off');
    case 4
        set(data_OP.hLinear, 'Visible', 'off');
        set(data_OP.hQuadratic, 'Visible', 'off');
        set(data_OP.hPolynomial, 'Visible', 'off');
        set(data_OP.Load_OF, 'Enable', 'on');
        set(data_OP.Display_OF, 'Visible', 'on');
end

%LOAD
function Sub_RunVariableFile(~,~)
global data_OP Optim
if data_OP.ld == 0
   Optim.x = [];
   [file,path] = uigetfile('*.m');
   run([path,file]); 
end
n = size(Optim.x);
n2 = size(data_OP.Variables);
if n(2)~=6 || isempty(Optim.x)
    disp('The loaded file should contain a cell of 6 columns named Optim.x having the following syntax: Optim.x = {Name, Property, Unit, Lower Bound, Initial Value, Upper Bound}');
    return;
end
for p=1:n(1)
    if Optim.x{p,4}>=Optim.x{p,6}
        disp('The value of the upper bound should be higher than that of the lower bound');
        return;
    elseif isempty(Optim.x{p,4})
        disp('If the variable is not left-bounded, set the lower bound to -inf. If not, please input a valid value');
        return;
    elseif isempty(Optim.x{p,6})
        disp('If the variable is not right-bounded, set the upper bound to inf. If not, please input a valid value');
        return;
    end
    if Optim.x{p,5}<Optim.x{p,4} || Optim.x{p,5}>Optim.x{p,6}
        disp('The initial value should lay between the lower and upper bounds.');
        return;
    end
    if isempty(Optim.x{p,3})
        disp('Please choose a unit for each variable. If the variable is dimensionless, assign - as the unit.');
        return;
    end
    for p2=p+1:n(1)
        if strcmp(Optim.x{p},Optim.x{p2})
            disp('Each variable is unique. Please assign different names for every variable.');
            return;
        end
    end
    for p3 = 1:n2(1)
        if strcmp(Optim.x{p}, data_OP.Variables(p3,1))==1
            disp('Each variable should be unique. Please assign names to your variables not already found in the table.');
            return;
        end
    end
end
for p = 1:n(1)
    Optim.x{p,4} = num2str(Optim.x{p,4});
    Optim.x{p,5} = num2str(Optim.x{p,5});
    Optim.x{p,6} = num2str(Optim.x{p,6});
end
data_OP.Variables = [data_OP.Variables; Optim.x];
set(data_OP.variabletable, 'Data', data_OP.Variables);

assignin('base','Optim',Optim);

function Sub_RunObjFuncFile(~,~)
global data_OP Optim
data_OP.app = 0;
if data_OP.ld == 0
   Optim.obj_func = [];
   Optim.Options = [];
   [file,path] = uigetfile('*.m');
   run([path,file]); 
end
data_OP.Options = Optim.Options; 
if isempty(Optim.obj_func)
    disp('The loaded file should contain an objective function named Optim.obj_func');
    return;
end
if ischar(Optim.obj_func)
    set(data_OP.Display_OF, 'String', Optim.obj_func);
    data_OP.app = 1;
else
    set(data_OP.Display_OF, 'String', func2str(Optim.obj_func));
end
set(data_OP.Display_OF, 'Enable', 'off');
if strcmp(Optim.Opt_case, 'Min')
    set(data_OP.checkbox_min, 'Value', 1);
    set(data_OP.checkbox_max, 'Value', 0);
elseif strcmp(Optim.Opt_case, 'Max')
    set(data_OP.checkbox_max, 'Value', 1);
    set(data_OP.checkbox_min, 'Value', 0);
end
assignin('base','Optim',Optim);

function Sub_RunConstraintFile(~,~)
global data_OP Optim
if data_OP.ld == 0
    Optim.c = [];
    Optim.ceq = [];
    [file,path] = uigetfile('*.m');
    run([path,file]);
end
if isempty(Optim.c) && isempty(Optim.ceq)
    disp('The loaded file should contain a cell of functions named Optim.c and/or a cell of functions named Optim.ceq.');
end
nc = size(Optim.c);
nceq = size(Optim.ceq);
if nc(1)>1 || nceq(1)>1
    disp('The Optim.c and Optim.ceq cells should be 1xn cells.');
    return;
end
c = '';
ceq = '';
for p = 1:nc(2)
    c = [c,'  ',func2str(Optim.c{p}),'<0'];
end
for p = 1:nceq(2)
    ceq = [ceq,'  ',func2str(Optim.ceq{p}),'=0'];
end
set(data_OP.Display_C, 'String', c);
set(data_OP.Display_Ceq, 'String', ceq);
data_OP.c = Optim.c;
data_OP.ceq = Optim.ceq;
assignin('base','Optim',Optim);

function Sub_LoadProblem(~,~)
global data_OP Optim
data_OP.Variables = [];
set(data_OP.variabletable,'Data',data_OP.Variables);
data_OP.ld = 1;
data_OP.reg = 0;
Optim.x = [];
Optim.obj_func = [];
Optim.c = [];
Optim.ceq = [];
Optim.A = [];
Optim.Aeq = [];
Optim.b = [];
Optim.beq = [];
Optim.Options = [];
data_OP.c = [];
data_OP.ceq = [];

assignin('base','Optim',[]);

[file,path] = uigetfile('*.m');
run([path,file]);

Sub_RunVariableFile
Sub_RunObjFuncFile
Sub_RunConstraintFile
set(data_OP.popupmenu_OF, 'Value', 4);
set(data_OP.Display_OF, 'Visible', 'on');
A1 = [Optim.b, Optim.A];
Aeq1 = [Optim.beq, Optim.Aeq];
if size(A1,1)<=1 && size(Aeq1,1)<=1
    set(data_OP.CR1edit, 'String', num2str(Aeq1));
    set(data_OP.CR2edit, 'String', num2str(A1));
else
    data_OP.reg = 1;
    set(data_OP.CR1edit, 'String', 'registered');
    set(data_OP.CR2edit, 'String', 'registered');
end
data_OP.ld = 0;

function Sub_ChangeObjFuncSign(~,~)
global data_OP
value_min = get(data_OP.checkbox_min, 'Value');
value_max = get(data_OP.checkbox_max, 'Value');
if value_min == 1
    set(data_OP.checkbox_max, 'Value', 0);
end
if value_max ==1
    set(data_OP.checkbox_min, 'Value', 0);
end

function [c,ceq] = Sub_NonLinearConstraints(x)
global data_OP Optim
if data_OP.norm == 1
for p=1:size(x,1)
    x(p)=x(p)*(Optim.ub(p)-Optim.lb(p))+Optim.lb(p);
end
end
if isempty(data_OP.c)
    c = [];
else
   for p = 1:size(data_OP.c, 2)
    c(p) = data_OP.c{p}(x);
   end
end 
if isempty(data_OP.ceq)
    ceq = [];
else
    for p = 1:size(data_OP.ceq, 2)
     ceq(p) = data_OP.ceq{p}(x);
    end
end
Optim.C = [Optim.C, c'];
Optim.Ceq = [Optim.Ceq, ceq'];

function [result] = Sub_Obj_Func(x)
global data_OP Optim

%dimensionalisation
if data_OP.norm==1
    for p=1:size(x,1)
        x(p) = x(p)*(Optim.ub(p)-Optim.lb(p))+Optim.lb(p);
    end
end

%minimization/maximization
switch data_OP.popupmenu_OF.Value
    case 1
        a2 = get(data_OP.CMedit, 'String');
        a1 = str2num(a2);
        if min(size(a1))~=1 || size(a1)~=size(x,1)+1
            disp('Please input a horizontal vector. The size of the vector should exceed the number of decision variables only by 1.');
            return;
        else
            a = a1(2:end);
            fun = @(x)(a*x + a1(1));
        end
    case 2
        A1 = get(data_OP.Aedit, 'String');
        A = str2num(A1);
        H = str2num(get(data_OP.Hedit, 'String'));
        b = str2num(get(data_OP.bedit, 'String'));
        if max(size(b))~=1 || size(A)~=size(x,1) || size(H,1)~=size(H,2) || size(H,1)~=size(x,1)
            disp('Please remember that the constant coefficient is a number, the A matrix is a horizontal vector whose size is the same as the number of decision variables, and the H matrix is a square matrix with whose dimensions are equal to the number of decision variables.');
            return;
        else
            fun = @(x)(x'*H*x + A*x + b);
        end
    case 3
        V = str2num(get(data_OP.V, 'String'));
        bn = str2num(get(data_OP.bnedit, 'String'));
        n = size(V);   %n(1) is the number of decision variables and n(2) is the degree of the equation
        if max(size(bn))~=1 || size(V,1)~=size(x,1)
            disp('The constant term should be a number, while the number of columns of the Coeff/degree matrix are the same as the number of decision variables.');
            return;
        else
            fun = @(x)bn;
            for p=1:n(2)
                f = @(x)(x'.^(n(2)+1-p)*V(:,p));
                fun = @(x) fun(x) + f(x);
            end
        end
    case 4        
        if data_OP.app == 1 %external application;        
            fin = fopen('input.dat','w');
            fprintf(fin,'%d ',x);
            fclose(fin);        
            status = dos(['"',Optim.obj_func,'" input.dat output.dat']);
            fun = dlmread('output.dat');
        else
            fun = Optim.obj_func;
        end
        
end
value_max = get(data_OP.checkbox_max, 'Value');
if value_max==1 && data_OP.app==0
    fun = @(x)-1*fun(x);
elseif value_max==1 && data_OP.popupmenu_OF.Value==4 && data_OP.app==1
    fun = -1*fun;
end

if data_OP.popupmenu_OF.Value~=4 || data_OP.app==0 
    result = fun(x);
elseif data_OP.popupmenu_OF.Value==4 && data_OP.app==1
    result = fun;
end

data_OP.x =  x.';
data_OP.xhistory = [data_OP.xhistory data_OP.x.'];
data_OP.result = [data_OP.result result];
Optim.iter = Optim.iter + 1;
s = get(data_OP.checkbox_save, 'Value');
pl = get(data_OP.checkbox_plot, 'Value');
if pl==1
    Sub_Graph(x);
end
if s==1
    Sub_Save(x,result);
end

function Sub_RunOptimisation(~,~)
global data_OP Optim
data_OP.norm = 1;
data_OP.x = [];
data_OP.xhistory = [];
data_OP.xrel = [];
data_OP.result = [];
Optim.iter = 0;
Optim.xhistory = [];
Optim.results = [];
Optim.C = [];
Optim.Ceq = [];
x = data_OP.Variables(:,1);
if data_OP.reg == 1
    Ain1 = [Optim.b, Optim.A];
    Aeq1 = [Optim.beq, Optim.Aeq];
else
    Aeq1 = str2num(get(data_OP.CR1edit, 'String'));
    Ain1 = str2num(get(data_OP.CR2edit, 'String'));
end
if ~isempty(Aeq1) && size(Aeq1,2)~=size(x,1)+1
    disp('The number of columns of the linear equality matrix should only exceed the number of decision variables by one.');
    return;
end
if isempty(Aeq1)
    Aeq = [];
    beq = [];
else
    Aeq = Aeq1(:,2:end);
    beq = Aeq1(:,1);
end
if ~isempty(Ain1) && size(Ain1,2)~=size(x,1)+1
    disp('The number of columns of the linear inequality matrix should only exceed the number of decision variables by one.');
    return;
end
if isempty(Ain1)
    Ain = [];
    bin = [];
else
    Ain = Ain1(:,2:end);
    bin = Ain1(:,1);
end
Optim.lb = [];
Optim.ub = [];
for p=1:size(x,1)
    Optim.lb(1,p)=str2double(data_OP.Variables(p,4));
    x0(1,p)=str2double(data_OP.Variables(p,5));
    Optim.ub(1,p)=str2double(data_OP.Variables(p,6));
    if Optim.lb(1,p)==-inf || Optim.ub(1,p)==+inf
        data_OP.norm = 0;
    end
    xrel(1,p)=(x0(p)-Optim.lb(p))/(Optim.ub(p)-Optim.lb(p));
    lbrel(1,p)=0;
    ubrel(1,p)=1;
end
Optim.lb = Optim.lb(:);
Optim.ub = Optim.ub(:);
x0 = x0(:);
xrel = xrel(:);
lbrel = lbrel(:);
ubrel = ubrel(:);
if data_OP.norm == 0
    lbrel = Optim.lb;
    ubrel = Optim.ub;
    xrel = x0;
end
if isempty(data_OP.c) && isempty(data_OP.ceq)
   nonlcon = [];
else
    nonlcon = @Sub_NonLinearConstraints;
end
value_min = get(data_OP.checkbox_min, 'Value');
value_max = get(data_OP.checkbox_max, 'Value');
if value_min == 0 && value_max == 0
    disp('Please choose the objective of the optimisation: Minimisation or Maximisation.');
    return;
end

data_OP.h1 = [];
data_OP.h2 = [];
data_OP.h3 = [];
data_OP.h4 = [];
data_OP.xhistory = [];
options = data_OP.Options;
x = fmincon(@Sub_Obj_Func,xrel,Ain,bin,Aeq,beq,lbrel,ubrel,nonlcon,options);
if data_OP.norm == 1
for p=1:size(x,1)
    x(p)=x(p)*(Optim.ub(p)-Optim.lb(p))+Optim.lb(p);
end
end
if value_max ==1
    [~,pos] = min(-data_OP.result);
    disp(['Decision Variables = ',num2str(data_OP.xhistory(:,pos)')]);
    disp(['Optimum = ',num2str(-data_OP.result(pos))]);
    Optim.results = -1.*data_OP.result;
else
    [~,pos] = min(data_OP.result);
    disp(['Decision Variables = ',num2str(data_OP.xhistory(:,pos)')]);
    disp(['Optimum = ',num2str(data_OP.result(pos))]);
    Optim.results = data_OP.result;
end

Optim.xhistory = data_OP.xhistory;
assignin('base','Optim',Optim);

function Sub_Graph(x)
global data_OP Optim

colplot = ['b';'r';'g';'k';'m';'c'];

%% FIGURE H1
if isempty(data_OP.h1)
    data_OP.h1 = figure(1);
    set(gcf,'Name','Objective Function');
    set(gcf,'Color',[1 1 1]);
    set(gcf, 'Position', [0 540/1080*data_OP.scrsz(4) 560/1920*data_OP.scrsz(3) 420/1080*data_OP.scrsz(4)]);
    
    plot(nan,nan,'ro','DisplayName','Unsatisfied constraints');
    hold on
    plot(nan,nan,'bo','DisplayName','Satisfied constraints');
    legend('show')
    ylabel('Objective function [-]')
    xlabel('Iterations [-]')
end

if ~isempty(data_OP.h1)
    set(0,'CurrentFigure',data_OP.h1)
    value_min = get(data_OP.checkbox_min, 'Value');
    value_max = get(data_OP.checkbox_max, 'Value');
    error = 0;
    for p = 1:size(data_OP.c, 2)
        if data_OP.c{p}(x)>0
            error = 1;
        end
    end
    for p = 1:size(data_OP.ceq,2)
        if data_OP.ceq{p}(x)~=0
            error = 1;
        end
    end
    if value_min == 1
        if error ==1
            plot(Optim.iter,data_OP.result(end),'ro', 'HandleVisibility', 'off')
        else
            plot(Optim.iter,data_OP.result(end),'bo', 'HandleVisibility', 'off')
        end
        hold on;
    elseif value_max == 1
        if error ==1
            plot(Optim.iter,-1.*data_OP.result(end),'ro', 'HandleVisibility', 'off')
        else
            plot(Optim.iter,-1.*data_OP.result(end),'bo', 'HandleVisibility', 'off')
        end
        hold on;
    end
end

%% FIGURE H2
if isempty(data_OP.h2)
    data_OP.h2 = figure(2);
    set(gcf,'Name','Non-Linear Constraints');
    set(gcf,'Color',[1 1 1]);
    set(gcf, 'Position', [560/1920*data_OP.scrsz(3) 540/1080*data_OP.scrsz(4) 560/1920*data_OP.scrsz(3) 420/1080*data_OP.scrsz(4)]);
    xlabel('Iterations [-]')
end

if ~isempty(data_OP.h2)
    set(0,'CurrentFigure',data_OP.h2)
    if isempty(data_OP.c) && isempty(data_OP.ceq)
        z = 0;
    elseif isempty(data_OP.c)
        z = size(data_OP.ceq,2);
    elseif isempty(data_OP.ceq)
        z = size(data_OP.c,2);
    else
        z = size(data_OP.c,2)+size(data_OP.ceq,2);
    end
    if z>0
        for count = 1 : z
            subplot(ceil(z^0.5),ceil(z/ceil(z^0.5)),count)
            if ~isempty(data_OP.c)
                if count <= size(data_OP.c,2)
                    plot(Optim.iter,data_OP.c{count}(x),['o' colplot(rem(count-1,size(colplot,1))+1,:)])
                    ylabel(['C' num2str(count)])
                    xlabel('Iterations [-]')
                else
                    plot(Optim.iter,data_OP.ceq{count-size(data_OP.c,2)}(x),['o' colplot(rem(count-1,size(colplot,1))+1,:)])
                    ylabel(['Ceq' num2str(count-size(data_OP.c))])
                    xlabel('Iterations [-]')
                end
            end
            if isempty(data_OP.c)
                plot(Optim.iter,data_OP.ceq{count}(x),['o' colplot(rem(count-1,size(colplot,1))+1,:)])
                ylabel(['Ceq' num2str(count)])
                xlabel('Iterations [-]')
            end
            hold on;            
        end
    end
end

%% FIGURE H3
if isempty(data_OP.h3)
    data_OP.h3 = figure(3);
    set(gcf,'Name','Decision Variables');
    set(gcf,'Color',[1 1 1]);
    set(gcf, 'Position', [0 35/1080*data_OP.scrsz(4) 560/1920*data_OP.scrsz(3) 420/1080*data_OP.scrsz(4)]);
end

if ~isempty(data_OP.h3)
    set(0,'CurrentFigure',data_OP.h3)
    for count = 1 : size(x,1)
        subplot(ceil(size(x,1)^0.5),ceil(size(x,1)/ceil(size(x,1)^0.5)),count)
        plot(Optim.iter,data_OP.x(count),['o' colplot(rem(count-1,size(colplot,1))+1,:)])
        hold on;
        ylabel([data_OP.Variables{count,1} ' [' data_OP.Variables{count,3} ']'])
        xlabel('Iterations [-]')
    end
end

%% FIGURE H4
if data_OP.norm == 1
if isempty(data_OP.h4)
    data_OP.h4 = figure(4);
    set(gcf,'Name','Normalised Decision Variables');
    set(gcf,'Color',[1 1 1]);
    set(gcf, 'Position', [560/1920*data_OP.scrsz(3) 35/1080*data_OP.scrsz(4) 560/1920*data_OP.scrsz(3) 420/1080*data_OP.scrsz(4)]);
end

if ~isempty(data_OP.h4)
    set(0,'CurrentFigure',data_OP.h4)
    for count = 1 : size(x,1)
        subplot(ceil(size(x,1)^0.5),ceil(size(x,1)/ceil(size(x,1)^0.5)),count)
        xrel = (data_OP.x(count)-Optim.lb(count))/(Optim.ub(count)-Optim.lb(count));
        plot(Optim.iter,xrel,['o' colplot(rem(count-1,size(colplot,1))+1,:)])
        hold on;
        ylim([0 1]);
        ylabel([data_OP.Variables{count,1} ' [%]'])
        xlabel('Iterations [-]')
    end
end
end
drawnow

function Sub_Save(x,fval)
global data_OP Optim
pname = '';
fname = ['ParamFEM_Optim', num2str(Optim.iter), '.txt'];
fid = fopen(strcat(pname,fname),'w');
fprintf(fid,'ParamFEM Optimization:\r\n');
fprintf(fid,'----------------------\r\n');
fprintf(fid,['Algorithm: fmincon' '\r\n']);
fprintf(fid,'\r\n');
fprintf(fid,['Iteration = ', num2str(Optim.iter), '\r\n']);
fprintf(fid,'\r\n');
fprintf(fid,'\r\n');
fprintf(fid,'Evaluated optimization values:\r\n');
for count=1:size(data_OP.Variables,1)
    fprintf(fid,'%s %c',data_OP.Variables{count,1});
end
fprintf(fid,'\r\n');
fprintf(fid,'%d \n',x);
fprintf(fid,'\r\n');
value_min = get(data_OP.checkbox_min, 'Value');
value_max = get(data_OP.checkbox_max, 'Value');
if value_min == 1
    fprintf(fid,'Min research \r\n');
    fprintf(fid,['ObjFunc = ' num2str(fval) '\r\n']);
elseif value_max == 1
    fprintf(fid,'Max research \r\n');
    fprintf(fid,['ObjFunc = ' num2str(-fval) '\r\n']);
end
disp(' ')
fclose('all');
clear fname fid ans